/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing.util;

import com.aptana.core.IFilter;
import com.aptana.core.util.StringUtil;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseRootNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseUtil {
    public static void addOffset(IParseNode node, int offset) {
        ParseUtil.addOffset(node, offset, true);
    }

    public static void addOffset(IParseNode node, final int offset, boolean recursive) {
        IFilter<IParseNode> function = new IFilter<IParseNode>(){

            public boolean include(IParseNode item) {
                if (item instanceof ParseNode) {
                    ((ParseNode)item).addOffset(offset);
                }
                return true;
            }
        };
        ParseUtil.treeApply(node, function, recursive);
    }

    public static String toTreeString(IParseNode node) {
        ArrayList<String> parts = new ArrayList<String>();
        ParseUtil.toTreeString(parts, node);
        return StringUtil.concat(parts);
    }

    private static void toTreeString(List<String> buffer, IParseNode node) {
        buffer.add("(");
        buffer.add(node.getElementName());
        if (node.hasChildren()) {
            IParseNode lastChild = node.getLastChild();
            buffer.add(" ");
            for (IParseNode child : node) {
                ParseUtil.toTreeString(buffer, child);
                if (child == lastChild) continue;
                buffer.add(" ");
            }
        }
        buffer.add(")");
    }

    public static void treeApply(IParseNode node, IFilter<IParseNode> function) {
        ParseUtil.treeApply(node, function, true);
    }

    public static void treeApply(IParseNode node, IFilter<IParseNode> function, boolean recursive) {
        if (node == null || function == null) {
            return;
        }
        LinkedList<IParseNode> queue = new LinkedList<IParseNode>();
        queue.offer(node);
        while (!queue.isEmpty()) {
            int i;
            int len;
            IParseNode current = (IParseNode)queue.poll();
            if (!function.include((Object)current)) break;
            if (!recursive) continue;
            if (current instanceof ParseRootNode) {
                IParseNode[] commentNodes = ((ParseRootNode)node).getCommentNodes();
                len = commentNodes.length;
                i = 0;
                while (i < len) {
                    queue.offer(commentNodes[i]);
                    ++i;
                }
            }
            IParseNode[] children = current.getChildren();
            len = children.length;
            i = 0;
            while (i < len) {
                IParseNode child = children[i];
                queue.offer(child);
                ++i;
            }
        }
    }

    public static void treeApply(IParseNode node, IASTVisitor function) {
        ParseUtil.treeApply(node, function, true);
    }

    public static void treeApply(IParseNode node, IASTVisitor function, boolean recursive) {
        if (node == null || function == null) {
            return;
        }
        LinkedList<QueueEntry> queue = new LinkedList<QueueEntry>();
        queue.add(new QueueEntry(node, true));
        while (!queue.isEmpty()) {
            QueueEntry current = (QueueEntry)queue.remove(0);
            if (current.enter) {
                int j;
                int len;
                if (!function.enterNode(current.node)) break;
                if (!recursive) continue;
                int i = 0;
                if (current.node instanceof ParseRootNode) {
                    IParseNode[] commentNodes = ((ParseRootNode)node).getCommentNodes();
                    len = commentNodes.length;
                    j = 0;
                    while (j < len) {
                        IParseNode commentNode = commentNodes[j];
                        queue.add(i++, new QueueEntry(commentNode, true));
                        ++j;
                    }
                }
                IParseNode[] children = current.node.getChildren();
                len = children.length;
                j = 0;
                while (j < len) {
                    IParseNode child = children[j];
                    queue.add(i++, new QueueEntry(child, true));
                    ++j;
                }
                queue.add(i++, new QueueEntry(current.node, false));
                continue;
            }
            if (!function.exitNode(current.node)) break;
        }
    }

    public static void trimToSize(IParseNode node) {
        ParseUtil.trimToSize(node, true);
    }

    public static void trimToSize(IParseNode node, boolean recursive) {
        IFilter<IParseNode> function = new IFilter<IParseNode>(){

            public boolean include(IParseNode item) {
                if (item instanceof ParseNode) {
                    ((ParseNode)item).trimToSize();
                }
                return true;
            }
        };
        ParseUtil.treeApply(node, function, recursive);
    }

    private ParseUtil() {
    }

    public static interface IASTVisitor {
        public boolean enterNode(IParseNode var1);

        public boolean exitNode(IParseNode var1);
    }

    private static class QueueEntry {
        private IParseNode node;
        private boolean enter;

        public QueueEntry(IParseNode node, boolean enter) {
            this.node = node;
            this.enter = enter;
        }
    }
}

